#pragma newdecls required
#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <sdkhooks>

#define MODEL_WITCH			"models/infected/witch.mdl"
#define MODEL_W_MOLOTOV		"models/w_models/weapons/w_eq_molotov.mdl"
#define SPRITE_ARROW_DOWN	"materials/vgui/scroll_down.vmt"
#define DEBUG 0

const int WEAPON_MAX_PER_WITCH = 6;
const float g_fButtonTime = 1.5;

int Anim[90];
int AnimCount = 2;
int WitchEnt[MAXPLAYERS+1];
bool g_bClientHasButton[MAXPLAYERS+1];
float PressTime[MAXPLAYERS+1];
float LastTime[MAXPLAYERS+1];
int WeaponFireEnt[MAXPLAYERS+1];
bool WitchViewOff[MAXPLAYERS+1];
float OffSets[100][3];
int lastWitchAttacker[2048+1];
int lastWitchHumanAttacker[2048+1];
int best_anim_onback;
int best_anim_down;

int GameMode;
int L4D2Version;

ConVar l4d_witch_guard_bestpose_onback;
ConVar l4d_witch_guard_bestpose_ondown;
ConVar l4d_witch_guard_pose_onback;
ConVar l4d_witch_guard_pose_down;
ConVar l4d_witch_guard_damage;
ConVar l4d_witch_guard_range;
ConVar l4d_witch_guard_gun_count;
ConVar l4d_witch_guard_shotonback;
ConVar l4d_witch_guard_steal;
ConVar l4d_witch_guard_spriteowner;
ConVar l4d_witch_guard_prioritize_human_players;
ConVar l4d_witch_guard_give_random;
ConVar l4d_witch_guard_detect_thirdperson;
ConVar l4d_witch_guard_enable;
ConVar l4d_witch_guard_weapon_type;

int g_iCvarBestPoseOnBack;
int g_iCvarBestPoseOnDown;
int g_iCvarPoseOnBack;
int g_iCvarPoseOnDown;
float g_fCvarGuardDamage;
float g_fCvarGuardRange;
int g_iCvarGuardGunCount;
int g_iCvarGuardShotOnBack;
int g_iCvarGuardSteal;
int g_iCvarGuardSpriteOwner;
int g_iCvarGuardPrioritizeHumanPlayers;
int g_iCvarGuardGiveRandom;
int g_iCvarDetectThirdPerson;
bool g_bEnable;
int g_iCvarGuardWeaponType;



int WitchGuardMolotov[MAXPLAYERS+1];
int WitchGuardSprite[MAXPLAYERS+1];
int WitchGuardButton[MAXPLAYERS+1];
int WitchGuardEnt[MAXPLAYERS+1];
float WitchGuardScanTime[MAXPLAYERS+1];
int WitchGuardWeaponEnt[MAXPLAYERS+1][WEAPON_MAX_PER_WITCH];
int WitchGuardCount;
bool bThirdPerson[MAXPLAYERS+1];
int g_iSpriteOwner[2048];
Handle g_hTimerAnim[MAXPLAYERS+1];
Handle g_hOnPutGround, g_hOnRemoveGround;

/*
	1.4.10-B (05-Aug-2022)
	 - Added preserving of witch color.
	 - Fixed compilation warnings on SM 1.11

	1.4.9-B (26-Oct-2021)
	 - Added WG_WitchRemove native.
	 - Added OnWitchGuard_PutGround forward.
	 - Added OnWitchGuard_RemoveGround forward.

	1.4.8-B (26-Apr-2021)
	 - Fixed rare invalid client entity error in CreateButton.

	1.4.7-B (21-Mar-2020)
	 - Code is beautified.
	 - Optimizations.
	 - Fixed anim timer doesn't stop in some cases and target wrong entities.
	 - Cached ConVar values.
	 - Some protections against crash.
	 - Added ConVar: "l4d_witch_guard_detect_thirdperson" - Show witch on back when some third-person actions happen? 0 = Disable (can increase performance), 1 = Enable.
	 - Added ConVar: "l4d_witch_guard_enable" - Enable this plugin? 0 = No, 1 = Yes.
	 - Added safe unloading.
	Included Marttt changes from 1.4.9.4:
	 - Button for pickup the witch is now added through a timer 1.5 seconds later.
	Included Marttt changes from 1.4.9.5:
	 - l4d_witch_guard_bestpose_onback ? 0: random pose, 1: best pose, 2: specific pose (uses pose_onback cvars)
	 - l4d_witch_guard_bestpose_ondown ? 0: random pose, 1: best pose, 2: specific pose (uses pose_down cvars)
	 - l4d_witch_guard_pose_down ? 0: off, 1-82: default witch pose while down. (l4d_witch_guard_bestpose_onback must be: 2)
	 - l4d_witch_guard_pose_onback ? 0: off, 1-82: default witch pose while on back. (l4d_witch_guard_bestpose_onback must be: 2)
	
	1.4.6-B
	 - code clear, performance, safety and translation optimizations.
	 - added support for custom witch models.
	 - fixed conflict with CPR plugin (Ctrl + E is no more trigger witch guard).
	 - restored L4D1 support.
	 
	 New (optional) requirement: ThirdPersonShoulder_Detect plugin by Lux:
	 https://forums.alliedmods.net/showthread.php?p=2529779
	 
	 Credits:
	  - Lux - for third person detection plugin.
	  - Mr. GameOver - for third person detection (in L4D1).
	 
*/

public Plugin myinfo =
{
	name = "Witch Guard",
	author = "Pan XiaoHai (fork by Dragokas & Mart)",
	description = "Witch killer takes the witch on his back and uses it as a guard",
	version = "1.4.10-B",
	url = "https://forums.alliedmods.net/showthread.php?t=166138"
}

public APLRes AskPluginLoad2(Handle myself, bool late, char[] error, int err_max)
{
	EngineVersion test = GetEngineVersion();
	if ( test == Engine_Left4Dead2 )
	{
		L4D2Version = true;
	}
	else if ( test != Engine_Left4Dead )
	{
		strcopy(error, err_max, "Plugin only supports Left 4 Dead 1 & 2.");
		return APLRes_SilentFailure;
	}
	g_hOnPutGround = CreateGlobalForward("OnWitchGuard_PutGround", ET_Ignore, Param_Cell, Param_Cell, Param_Array);
	g_hOnRemoveGround = CreateGlobalForward("OnWitchGuard_RemoveGround", ET_Ignore, Param_Cell, Param_Cell, Param_Array);
	CreateNative("WG_WitchRemove", NATIVE_WitchRemove);
	return APLRes_Success;
}

public int NATIVE_WitchRemove(Handle plugin, int numParams)
{
	if( numParams < 1 )
		ThrowNativeError(SP_ERROR_PARAM, "Invalid numParams");
	
	int iWitch = GetNativeCell(1);
	KillGuardByEntity(iWitch);
	return 0;
}

public void OnPluginStart()
{
	LoadTranslations("common.phrases");
	LoadTranslations("witch_guard.phrases");

	GameCheck();
	L4D2Version ? SetAnimL4d2() : SetAnimL4d1();
	if( GameMode != 1) return;

	char sBestAnimOnBack[3];
	Format(sBestAnimOnBack, sizeof(sBestAnimOnBack), "%i", best_anim_onback);

	char sBestAnimDown[3];
	Format(sBestAnimDown, sizeof(sBestAnimDown), "%i", best_anim_down);

	l4d_witch_guard_bestpose_onback = 			CreateConVar("l4d_witch_guard_bestpose_onback", 			"0", 		"0: random pose, 1: best pose, 2: specific pose (uses pose_onback cvars)", FCVAR_NOTIFY, true, 0.0, true, 2.0);
	l4d_witch_guard_bestpose_ondown = 			CreateConVar("l4d_witch_guard_bestpose_ondown", 			"1", 		"0: random pose, 1: best pose, 2: specific pose (uses pose_down cvars)", FCVAR_NOTIFY, true, 0.0, true, 2.0);
	l4d_witch_guard_pose_onback = 				CreateConVar("l4d_witch_guard_pose_onback", 		sBestAnimOnBack, 	"0: off, 1-82: default witch pose while on back. (l4d_witch_guard_bestpose_onback must be: 2)", FCVAR_NOTIFY, true, 0.0, true, 82.0);
	l4d_witch_guard_pose_down = 				CreateConVar("l4d_witch_guard_pose_down", 			sBestAnimDown, 		"0: off, 1-82: default witch pose while down. (l4d_witch_guard_bestpose_onback must be: 2)", FCVAR_NOTIFY, true, 0.0, true, 82.0);
	//l4d_witch_onback_bestpose = 				CreateConVar("l4d_witch_onback_bestpose", 					"0", 		"0: random pose, 1: best pose", FCVAR_NOTIFY);
	l4d_witch_guard_damage = 					CreateConVar("l4d_witch_guard_damage", 						"0.5", 		"attack dmage, 1.0: normal [0.1, 1.0]", FCVAR_NOTIFY);
	l4d_witch_guard_range = 					CreateConVar("l4d_witch_guard_range", 						"600.0", 	"attack range", FCVAR_NOTIFY);
	l4d_witch_guard_gun_count = 				CreateConVar("l4d_witch_guard_gun_count", 					"3", 		"gun count", FCVAR_NOTIFY, true, 0.0, true, float(WEAPON_MAX_PER_WITCH));
	l4d_witch_guard_shotonback = 				CreateConVar("l4d_witch_guard_shotonback", 					"0", 		"0: do not shot on back, 1: shot", FCVAR_NOTIFY);
	l4d_witch_guard_steal = 					CreateConVar("l4d_witch_guard_steal", 						"0", 		"Enables/Disables other clients to steal(pick up) a Witch from other owners while on the ground. 0 = Disable, 1 = Enable.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_spriteowner = 				CreateConVar("l4d_witch_guard_spriteowner", 				"1", 		"Show/Hide the sprite indicating which Witch in the ground is from the owner. 0 = Hide, 1 = Show.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_prioritize_human_players = 	CreateConVar("l4d_witch_guard_prioritize_human_players", 	"0", 		"Prioritize human players. 0 = Disable, 1 = Enable.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_give_random = 				CreateConVar("l4d_witch_guard_give_random", 				"0", 		"Give witch to a random player if the killer already has one. 0 = Disable, 1 = Enable.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_detect_thirdperson = 		CreateConVar("l4d_witch_guard_detect_thirdperson", 			"1", 		"Show witch on back when some third-person actions happen? 0 = Disable (can increase performance), 1 = Enable.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_enable = 					CreateConVar("l4d_witch_guard_enable", 						"1", 		"Enable this plugin? 0 = No, 1 = Yes.", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	l4d_witch_guard_weapon_type = 				CreateConVar("l4d_witch_guard_weapon_type", 				"0", 		"Weapon type given to the witch. 0 = Random, 1 = Assault Rifle, 2 = Hunting Rifle, 3 = Auto Shotgun.", FCVAR_NOTIFY, true, 0.0, true, 1.0);


	
	AutoExecConfig(true, "l4d_witch_guard");
	
	RegConsoleCmd("sm_witch", 		sm_witch,							"Switch third person witch view on/off");
	RegConsoleCmd("sm_witchpose", 	sm_witchpose,						"Change witch pose on spine");
	
	RegAdminCmd("sm_givewitch", 	AdmCmdGiveWitch, ADMFLAG_ROOT, 		"Gives a Witch to the target");
	
	ResetAllState();
	GetCvars();
	
	l4d_witch_guard_bestpose_onback.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_bestpose_ondown.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_pose_onback.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_pose_down.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_damage.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_range.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_gun_count.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_shotonback.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_steal.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_spriteowner.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_prioritize_human_players.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_give_random.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_detect_thirdperson.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_enable.AddChangeHook (OnConVarChanged);
	l4d_witch_guard_weapon_type.AddChangeHook (OnConVarChanged);
}

public void OnPluginEnd()
{
	UnloadWitches();
}

void UnloadWitches()
{
	for ( int i = 1; i <= MaxClients; i++ )
	{
		DeleteDecoration(i);
	}
	
	for( int i = 0; i < WitchGuardCount; i++ )
	{
		if( IsValidEntityEx(WitchGuardButton[i]) )
		{
			UnhookSingleEntityOutput(WitchGuardButton[i], "OnTimeUp", OnPressed);
			AcceptEntityInput(WitchGuardButton[i], "kill");
		}
		KillGuard(i);
	}
}

void OnConVarChanged(ConVar convar, const char[] oldValue, const char[] newValue)
{
	GetCvars();
}

void GetCvars()
{
	g_iCvarBestPoseOnBack = l4d_witch_guard_bestpose_onback.IntValue;
	g_iCvarBestPoseOnDown = l4d_witch_guard_bestpose_ondown.IntValue;
	g_iCvarPoseOnBack = l4d_witch_guard_pose_onback.IntValue;
	g_iCvarPoseOnDown = l4d_witch_guard_pose_down.IntValue;
	g_fCvarGuardDamage = l4d_witch_guard_damage.FloatValue;
	g_fCvarGuardRange = l4d_witch_guard_range.FloatValue;
	g_iCvarGuardGunCount = l4d_witch_guard_gun_count.IntValue;
	g_iCvarGuardShotOnBack = l4d_witch_guard_shotonback.IntValue;
	g_iCvarGuardSteal = l4d_witch_guard_steal.IntValue;
	g_iCvarGuardSpriteOwner = l4d_witch_guard_spriteowner.IntValue;
	g_iCvarGuardPrioritizeHumanPlayers = l4d_witch_guard_prioritize_human_players.IntValue;
	g_iCvarGuardGiveRandom = l4d_witch_guard_give_random.IntValue;
	g_iCvarDetectThirdPerson = l4d_witch_guard_detect_thirdperson.IntValue;
	g_bEnable = l4d_witch_guard_enable.BoolValue;
	g_iCvarGuardWeaponType = l4d_witch_guard_weapon_type.IntValue;

	SetHook();
}

void SetHook()
{
	static bool bHooked;
	
	if ( g_bEnable ) {
		if (!bHooked) {
			HookEvent("infected_hurt", 			infected_hurt);
			HookEvent("witch_killed", 			witch_killed, 		EventHookMode_Pre);
			HookEvent("player_bot_replace",		player_bot_replace );
			HookEvent("bot_player_replace", 	bot_player_replace );
			HookEvent("round_start", 			round_end);
			HookEvent("round_end", 				round_end);
			HookEvent("finale_win", 			round_end);
			HookEvent("mission_lost", 			round_end);
			HookEvent("map_transition", 		round_end); 
			HookEvent("player_death", 			player_death);
			bHooked = true;
		}
	} else {
		if (bHooked) {
			UnhookEvent("infected_hurt", 		infected_hurt);
			UnhookEvent("witch_killed", 		witch_killed, 	EventHookMode_Pre);
			UnhookEvent("player_bot_replace",	player_bot_replace );
			UnhookEvent("bot_player_replace", 	bot_player_replace );
			UnhookEvent("round_start", 			round_end);
			UnhookEvent("round_end", 			round_end);
			UnhookEvent("finale_win", 			round_end);
			UnhookEvent("mission_lost", 		round_end);
			UnhookEvent("map_transition", 		round_end); 
			UnhookEvent("player_death", 		player_death);
			bHooked = false;
			UnloadWitches();
			ResetAllState();
		}
	}
}

public void TP_OnThirdPersonChanged(int iClient, bool bIsThirdPerson)
{
	bThirdPerson[iClient] = bIsThirdPerson;
}

Action AdmCmdGiveWitch(int client, int args)
{
	char sArg[256];
	GetCmdArg(1, sArg, sizeof(sArg));

	int target_list[MAXPLAYERS], target_count;
	bool tn_is_ml;
	char target_name[MAX_TARGET_LENGTH];

	target_count = ProcessTargetString(sArg,
									   client,
									   target_list,
									   MAXPLAYERS,
									   COMMAND_FILTER_CONNECTED,
									   target_name,
									   sizeof(target_name),
									   tn_is_ml);

	if ( target_count <= 0 )
	{
		ReplyToTargetError(client, target_count);
		return Plugin_Handled;
	}

	for ( int i = 0; i < target_count; i++ )
	{
		if ( IsValidClient(target_list[i]) )
		{
			CreateDecoration(target_list[i], MODEL_WITCH, 255, 255, 255);
		}
	}
	return Plugin_Handled;
}

void GameCheck()
{
	char GameName[16];
	FindConVar("mp_gamemode").GetString(GameName, sizeof(GameName));

	if ( StrEqual(GameName, "survival", false) )
		GameMode = 3;
	else if ( StrEqual(GameName, "versus", false) || StrEqual(GameName, "teamversus", false) || StrEqual(GameName, "scavenge", false) || StrEqual(GameName, "teamscavenge", false) )
		GameMode = 2;
	else if ( StrEqual(GameName, "coop", false) || StrEqual(GameName, "realism", false) )
		GameMode = 1;
	else
	{
		GameMode = 0;
	}
}

public void OnMapStart()
{
	PrecacheModel(MODEL_WITCH, true);
	PrecacheModel(MODEL_W_MOLOTOV, true);
	PrecacheModel(SPRITE_ARROW_DOWN, true);
}

void SetAnimL4d2()
{
	OffSets[1]=view_as<float>({-5.000000,26.000000,-100.000000});
	OffSets[2]=view_as<float>({-3.000000,32.000000,-100.000000});
	OffSets[3]=view_as<float>({-1.000000,28.000000,-100.000000});
	OffSets[5]=view_as<float>({-1.000000,28.000000,-100.000000});
	OffSets[7]=view_as<float>({1.000000,26.000000,-100.000000});
	OffSets[8]=view_as<float>({-3.000000,26.000000,-100.000000});
	OffSets[10]=view_as<float>({-3.000000,24.000000,-100.000000});
	OffSets[16]=view_as<float>({1.000000,28.000000,-100.000000});
	OffSets[18]=view_as<float>({1.000000,32.000000,-100.000000});
	OffSets[35]=view_as<float>({-5.000000,4.000000,-100.000000});
	OffSets[37]=view_as<float>({1.000000,28.000000,-100.000000});
	OffSets[44]=view_as<float>({-1.000000,28.000000,-100.000000});
	OffSets[45]=view_as<float>({-1.000000,30.000000,-100.000000});
	OffSets[46]=view_as<float>({-1.000000,32.000000,-100.000000});
	OffSets[49]=view_as<float>({-3.000000,32.000000,-100.000000});
	OffSets[51]=view_as<float>({-1.000000,30.000000,-100.000000});
	OffSets[54]=view_as<float>({3.000000,32.000000,-100.000000});
	OffSets[55]=view_as<float>({-1.000000,30.000000,-100.000000});
	OffSets[59]=view_as<float>({-1.000000,28.000000,-100.000000});
	OffSets[61]=view_as<float>({-5.000000,24.000000,-100.000000});
	OffSets[62]=view_as<float>({-5.000000,22.000000,-100.000000});
	OffSets[66]=view_as<float>({-5.000000,30.000000,-100.000000});
	OffSets[73]=view_as<float>({-5.000000,0.000000,-100.000000});
	OffSets[74]=view_as<float>({1.000000,10.000000,-100.000000});
	OffSets[76]=view_as<float>({-5.000000,32.000000,-100.000000});
	OffSets[77]=view_as<float>({-5.000000,34.000000,-100.000000}); //best
	OffSets[79]=view_as<float>({-9.000000,20.000000,-100.000000});
	OffSets[80]=view_as<float>({-15.000000,18.000000,-100.000000});
	AnimCount = 0;
	for( int i = 0; i < 90; i++ )
	{
		if( OffSets[i][2] == -100.0 )
		{
			Anim[AnimCount]=i;
			AnimCount++;
		}
	}
	best_anim_onback = 77;
	best_anim_down = 3;
}

void SetAnimL4d1()
{
	OffSets[1]=view_as<float>({1.000000,32.000000,-100.000000});
	OffSets[3]=view_as<float>({-1.000000,28.000000,-100.000000});
	OffSets[4]=view_as<float>({1.000000,28.000000,-100.000000});
	OffSets[5]=view_as<float>({1.000000,32.000000,-100.000000});
	OffSets[6]=view_as<float>({1.000000,22.000000,-100.000000});
	OffSets[9]=view_as<float>({3.000000,26.000000,-100.000000});
	OffSets[29]=view_as<float>({-1.000000,30.000000,-100.000000});
	OffSets[32]=view_as<float>({-1.000000,30.000000,-100.000000});
	OffSets[36]=view_as<float>({1.000000,32.000000,-100.000000});
	OffSets[37]=view_as<float>({-1.000000,32.000000,-100.000000});
	OffSets[41]=view_as<float>({-1.000000,32.000000,-100.000000});
	OffSets[43]=view_as<float>({-1.000000,32.000000,-100.000000});
	OffSets[46]=view_as<float>({1.000000,32.000000,-100.000000});
	OffSets[47]=view_as<float>({1.000000,26.000000,-100.000000});
	OffSets[51]=view_as<float>({1.000000,24.000000,-100.000000});
	OffSets[53]=view_as<float>({-1.000000,20.000000,-100.000000});
	OffSets[54]=view_as<float>({-5.000000,20.000000,-100.000000});
	OffSets[57]=view_as<float>({-3.000000,20.000000,-100.000000});
	OffSets[65]=view_as<float>({-9.000000,2.000000,-100.000000});
	OffSets[66]=view_as<float>({-1.000000,14.000000,-100.000000});
	OffSets[68]=view_as<float>({-1.000000,36.000000,-100.000000});
	OffSets[69]=view_as<float>({-3.000000,32.000000,-100.000000}); //best
	OffSets[70]=view_as<float>({-1.000000,32.000000,-100.000000});
	OffSets[72]=view_as<float>({-9.0,18.0,-100.0});
	AnimCount=0;
	for( int i = 0; i < 90; i++ )
	{
		if( OffSets[i][2] == -100.0 )
		{
			Anim[AnimCount]=i;
			AnimCount++;
		}
	}
	best_anim_onback = 69;
	best_anim_down = 1;
}

public Action sm_witchpose(int client, int args)
{
	for( int i = 1; i <= MaxClients; i++ )
	{
		if( IsValidEntityEx(WitchEnt[i]) )
		{
			client = i;
			if( client && IsClientInGame(client) && IsPlayerAlive(client) && GetClientTeam(client)==2 )
			{
				int anim = Anim[ GetRandomInt(0,AnimCount-1) ];
				float ang[3];
				SetVector(ang, 0.0, 0.0, 90.0);
				float pos[3];
				pos[0] = OffSets[anim][0];
				pos[1] = OffSets[anim][1];

				TeleportEntity(WitchEnt[client], pos, ang, NULL_VECTOR);

				SetEntProp(WitchEnt[client], Prop_Send, "m_nSequence", anim);
				SetEntPropFloat(WitchEnt[client], Prop_Send, "m_flPlaybackRate", 1.0);
			}
		}
	}
	return Plugin_Continue;
}

public Action sm_witch(int client, int args)
{
	if( client )
	{
		WitchViewOff[client]=!WitchViewOff[client];
		if( !WitchViewOff[client] ) CPrintToChat(client, "%t", "View_On"); // \x04witch \x03view is \x04on");
		else CPrintToChat(client, "%t", "View_Off"); // \x04witch \x03view is \x04off, \x03but others still can see it on your back");

		if ( !WitchViewOff[client] && IsValidEntityEx(WitchEnt[client]) ) {
			static int g_testanim;
			g_testanim++;
			if ( g_testanim >= AnimCount ) g_testanim = 0;
			int anim = Anim[g_testanim];
			SetEntProp(WitchEnt[client], Prop_Send, "m_nSequence", anim);
			PrintToChatAll("New witch pose: %d", anim);
			SetEntPropFloat(WitchEnt[client], Prop_Send, "m_flPlaybackRate", 1.0);
		}
	}
	return Plugin_Handled;
}

public void infected_hurt(Event event, char[] name, bool dontBroadcast)
{
	int entityid = GetEventInt(event, "entityid");

	if ( !IsWitchEntity(entityid) )
		return;

	int userId = GetEventInt(event, "attacker");
	int attacker = GetClientOfUserId(userId);

	if ( IsValidClient(attacker) && GetClientTeam(attacker) == 2 && !IsValidEntityEx(WitchEnt[attacker]) )
	{
		lastWitchAttacker[entityid] = attacker;

		if ( !IsFakeClient(attacker) )
		{
			lastWitchHumanAttacker[entityid] = attacker;
		}
	}
}

public void OnClientDisconnect(int client)
{
	DeleteDecoration(client);
	delete g_hTimerAnim[client];
}

public void player_death(Event event, const char[] strName, bool DontBroadcast)
{
	int victim = GetClientOfUserId(event.GetInt("userid"));
	if( victim && victim <= MaxClients && IsClientInGame(victim) && GetClientTeam(victim) == 2)
	{
		DeleteDecoration(victim);
		delete g_hTimerAnim[victim];
	}
}

public void player_bot_replace(Event event, const char[] Spawn_Name, bool Spawn_Broadcast)
{
	// player has replaced by bot
	int client = GetClientOfUserId(event.GetInt("player"));
	if( client )
	{
		DeleteDecoration(client);
		delete g_hTimerAnim[client];
	}
}

public void bot_player_replace(Event event, const char[] Spawn_Name, bool Spawn_Broadcast)
{
	// player replaces a bot
	int bot = GetClientOfUserId(event.GetInt("bot"));
	if( bot )
	{
		DeleteDecoration(bot);
		delete g_hTimerAnim[bot];
	}
}

public void witch_killed(Event event, const char[] strName, bool DontBroadcast)
{
	int witch = event.GetInt("witchid");
	
	if ( IsValidEntityEx(witch) )
	{
		static int r,g,b,a;
		GetEntityRenderColor(witch, r, g, b, a);
		if ( r == 128 && g == 0 && b == 0 )
		{
			return;
		}
		
		int attacker = GetClientOfUserId(event.GetInt("userid"));

		if ( !attacker )
			attacker = lastWitchAttacker[witch];

		if ( g_iCvarGuardPrioritizeHumanPlayers && IsValidClient(attacker) && IsFakeClient(attacker) && IsValidClient(lastWitchHumanAttacker[witch]) )
			attacker = lastWitchHumanAttacker[witch];
		
		if ( g_iCvarGuardGiveRandom )
		{
			if ( !attacker || IsValidEntityEx(WitchEnt[attacker]) || g_bClientHasButton[attacker] )
				attacker = GetRandomPlayer(attacker);
		}
		
		lastWitchAttacker[witch] = 0;
		lastWitchHumanAttacker[witch] = 0;
		
		if( IsValidClient(attacker) )
		{
			if( IsClientInGame(attacker) && IsPlayerAlive(attacker) && GetClientTeam(attacker) == 2 )
			{
				static char sModel[PLATFORM_MAX_PATH];
				GetEntPropString(witch, Prop_Data, "m_ModelName", sModel, sizeof(sModel));
				//int r, g, b;
				//GetEntityRenderColor(witch, r, g, b);
				
				if ( CreateDecoration(attacker, sModel, r, g, b) )
				{
					switch (GetRandomInt(0, 4)) {
						case 0: CPrintToChat(attacker, "%t", "Witch_on_back0", attacker); // \x04%N \x03put witch on his back", attacker);
						case 1: CPrintToChat(attacker, "%t", "Witch_on_back1", attacker); // alternates ...
						case 2: CPrintToChat(attacker, "%t", "Witch_on_back2", attacker); //
						case 3: CPrintToChat(attacker, "%t", "Witch_on_back3", attacker); //
						case 4: CPrintToChat(attacker, "%t", "Witch_on_back4", attacker); //
					}
					CPrintToChat(attacker, "%t", "Keys1"); // "\x03press\x04!use button \x03to put witch down");
				}
			}
		}
	}
}

public void round_end(Event event, const char[] name, bool dontBroadcast)
{
	ResetAllState();
}

void ResetAllState()
{
	WitchGuardCount = 0;
	
	for( int i = 0; i <= MaxClients; i++ )
	{
		WitchEnt[i] = 0;
		g_bClientHasButton[i] = false;
		WeaponFireEnt[i] = 0;
		WitchGuardButton[i] = 0;
		WitchGuardMolotov[i] = 0;
		WitchGuardSprite[i] = 0;
		
		for( int j = 0; j < WEAPON_MAX_PER_WITCH; j++ )
		{
			 WitchGuardWeaponEnt[i][j] = 0;
		}
	}
}

void DeleteDecoration(int client, char[] sModel = "\0")
{
	int witchent = WitchEnt[client];
	int fireent = WeaponFireEnt[client];
	
	if ( !witchent && !fireent )
		return;
	
	WitchEnt[client] = 0;
	WeaponFireEnt[client] = 0;

	sModel[0] = '\0';

	if( IsSpineWitchEntity(witchent) )
	{
		GetEntPropString(witchent, Prop_Data, "m_ModelName", sModel, PLATFORM_MAX_PATH);
		AcceptEntityInput(witchent, "kill");
	}
	if( IsValidEntityEx(fireent) )
	{
		AcceptEntityInput(fireent, "kill");
	}
	if( client && IsClientInGame(client) )
	{
		SDKUnhook(client, SDKHook_PreThink, PreThinkClient);
	}
}

bool CreateDecoration(int client, char[] sModel, int r, int g, int b) // on client's spine
{
	if( IsValidEntityEx(WitchEnt[client]) )
		return false;
	
	int witch = CreateEntityByName("prop_dynamic_override");
	if ( witch != -1 )
	{
		DispatchKeyValue(witch, "model", sModel[0] != '\0' ? sModel : MODEL_WITCH );
		SetEntityRenderColor(witch, r, g, b);
		DispatchSpawn(witch);
		
		/*
		static char tname[16];
		FormatEx(tname, sizeof(tname), "target%d", client);
		DispatchKeyValue(client, "targetname", tname);
		DispatchKeyValue(witch, "parentname", tname);
		SetVariantString(tname);
		*/
		
		SetVariantString("!activator");
		AcceptEntityInput(witch, "SetParent", client);
		SetVariantString("medkit");
		AcceptEntityInput(witch, "SetParentAttachment");

		int anim = 0;
		switch( g_iCvarBestPoseOnBack )
		{
			case 0: anim = Anim[GetRandomInt(0,AnimCount-1)];
			case 1: anim = best_anim_onback;
			case 2: anim = g_iCvarPoseOnBack;
		}
		
		float pos[3];
		float ang[3];
		SetVector(pos, -5.0, 32.0, 0.0);
		pos[0]=OffSets[anim][0];
		pos[1]=OffSets[anim][1];
		SetVector(ang, 0.0, 00.0, 90.0);
		
		TeleportEntity(witch, pos, ang, NULL_VECTOR);
		
		SetEntProp(witch, Prop_Send, "m_CollisionGroup", 2);
		
		SetEntProp(witch, Prop_Send, "m_nSequence", anim);
		SetEntPropFloat(witch, Prop_Send, "m_flPlaybackRate", 1.0);
	}
	
	if( !g_iCvarBestPoseOnBack )
	{
		if ( g_hTimerAnim[client] == INVALID_HANDLE )
		{
			g_hTimerAnim[client] = CreateTimer(30.0, TimerAnimWitch, GetClientUserId(client), TIMER_FLAG_NO_MAPCHANGE | TIMER_REPEAT);
		}
	}
	
	SDKHook(witch, SDKHook_SetTransmit, Hook_SetTransmit); // hide witch on spine

	if( g_iCvarGuardShotOnBack == 1 )
	{
		int ent = CreateEntityByName("env_weaponfire");
		if ( ent != -1 )
		{
			float eye[3];
			GetClientEyePosition(client, eye);
			DispatchSpawn(ent);

			static char tName[16];
			FormatEx(tName, sizeof(tName), "target%d", client);
			DispatchKeyValue(client , "targetname", tName);

			DispatchKeyValueFloat(ent, "targetarc", 360.0);
			DispatchKeyValueFloat(ent, "targetrange", g_fCvarGuardRange);
			
			static char sWeaponType[2];
			if ( g_iCvarGuardWeaponType == 0 )
				FormatEx(sWeaponType, sizeof(sWeaponType), "%i", GetRandomInt(1,3));
			else
				FormatEx(sWeaponType, sizeof(sWeaponType), "%i", g_iCvarGuardWeaponType);
			
			DispatchKeyValue(ent, "weapontype", sWeaponType);
				
			DispatchKeyValue(ent, "targetteam", "3");
			DispatchKeyValueFloat(ent, "damagemod", g_fCvarGuardDamage);

			DispatchKeyValue(ent, "parentname", tName);
			SetVariantString(tName);
			AcceptEntityInput(ent, "SetParent", ent, ent, 0);
			SetVariantString("eyes"); //muzzle_flash
			AcceptEntityInput(ent, "SetParentAttachment");
			
			SetVector(eye, 0.0, 0.0, 15.0);
			TeleportEntity(ent, eye,NULL_VECTOR, NULL_VECTOR);
			AcceptEntityInput(ent, "Enable" );
		}
		WeaponFireEnt[client]=ent;
	}
	
	PressTime[client] = GetEngineTime();
	LastTime[client] = GetEngineTime();
	SDKUnhook(client, SDKHook_PreThink,  PreThinkClient);
	SDKHook( client, SDKHook_PreThink,  PreThinkClient);
	
	WitchEnt[client] = witch;
	
	#if DEBUG
	PrintToChatAll("Created witch decoration: %i", witch);
	#endif
	
	return (witch != 1);
}

int CreateWitchGuard(int client, char[] sModel, float out_witch_pos[3])
{
	if ( WitchGuardCount >= MaxClients )
		return -1;

	int anim = 0;
	switch( g_iCvarBestPoseOnDown )
	{
		case 0: anim = Anim[GetRandomInt(0, AnimCount-1)];
		case 1: anim = best_anim_down;
		case 2: anim = g_iCvarPoseOnDown;
	}
	
	float pos[3];
	float ang[3];
	float t[3];
	GetClientAbsOrigin(client, pos);
	GetClientEyeAngles(client, ang);
	ang[0]=0.0;
	
	GetAngleVectors(ang, t, NULL_VECTOR, NULL_VECTOR);
	NormalizeVector(t, t);
	ScaleVector(t, 20.0);
	AddVectors(pos, t, pos);
	
	/*
	GetClientEyeAngles(client, t);
	t[0]=0.0;
	t[1]+=90.0;
	*/

	int molotov = CreateEntityByName("molotov_projectile");
	if ( molotov != -1 )
	{
		SetEntityModel(molotov, MODEL_W_MOLOTOV);
		DispatchSpawn(molotov);
		SetEntityRenderMode(molotov, RENDER_TRANSCOLOR);
		SetEntityRenderColor(molotov, 0, 0, 0, 0);
		SetEntityMoveType(molotov, MOVETYPE_NONE);
		SetEntProp(molotov, Prop_Data, "m_CollisionGroup", 2);
		TeleportEntity(molotov, pos, ang, NULL_VECTOR);
	}

	static char tName[32];
	int witch = CreateEntityByName("prop_dynamic_override");
	if ( witch != -1 )
	{
		DispatchKeyValue(witch, "model", sModel[0] != '\0' ? sModel : MODEL_WITCH);
		DispatchSpawn(witch);
		SetEntProp(witch, Prop_Send, "m_nSequence", anim);
		SetEntPropFloat(witch, Prop_Send, "m_flPlaybackRate", 1.0);
		
		DispatchKeyValueFloat(witch, "fademindist", 10000.0);
		DispatchKeyValueFloat(witch, "fademaxdist", 20000.0);
		DispatchKeyValueFloat(witch, "fadescale", 0.0);
		
		if( L4D2Version )
		{
			SetEntProp(witch, Prop_Send, "m_iGlowType", 3);
			SetEntProp(witch, Prop_Send, "m_nGlowRange", 0);
			SetEntProp(witch, Prop_Send, "m_nGlowRangeMin", 600);
			int red = 0;
			int green = 150;
			int blue = 0;
			SetEntProp(witch, Prop_Send, "m_glowColorOverride", red + (green * 256) + (blue * 65536));
		}
		
		TeleportEntity(witch, pos, ang, NULL_VECTOR);
		
		out_witch_pos = pos;
		
		FormatEx(tName, sizeof(tName), "target%d", molotov );
		DispatchKeyValue(molotov, "targetname", tName);

		DispatchKeyValue(witch, "parentname", tName);
		SetVariantString(tName);
		AcceptEntityInput(witch, "SetParent", witch, witch, 0);
	}
	
	int env_sprite;

	if ( g_iCvarGuardSpriteOwner )
	{
		env_sprite = CreateEntityByName("env_sprite");
		
		if ( env_sprite != -1 )
		{
			DispatchKeyValue(env_sprite, "model", SPRITE_ARROW_DOWN);
			DispatchKeyValue(env_sprite, "rendermode", "1");
			//DispatchKeyValue(env_sprite, "rendercolor", "0 0 255");
			DispatchKeyValue(env_sprite, "renderamt", "240");
			DispatchKeyValue(env_sprite, "disablereceiveshadows", "1");
			DispatchKeyValue(env_sprite, "spawnflags", "1");
			DispatchKeyValueFloat(env_sprite, "fademindist", 0.0);
			DispatchKeyValueFloat(env_sprite, "fademaxdist", 250.0);
			
			DispatchSpawn(env_sprite);

			SetVariantString("!activator");
			AcceptEntityInput(env_sprite, "SetParent", witch);
			
			g_iSpriteOwner[env_sprite] = client;
			SDKHook(env_sprite, SDKHook_SetTransmit, SetTransmitSprite);

			float vPos[3];
			vPos[2] = 70.0;
			
			TeleportEntity(env_sprite, vPos, NULL_VECTOR, NULL_VECTOR);
		}
	}

	float pos2[3];
	float front = 0.0;
	float up = 35.0;
	float side = 25.0;
	
	int count = g_iCvarGuardGunCount;
	if( count < 1 )
	{
		count = 1;
	}
	else if( count > WEAPON_MAX_PER_WITCH )
	{
		count = WEAPON_MAX_PER_WITCH;
	}
	for( int i = 0; i < count; i++ )
	{
		int ent = CreateEntityByName("env_weaponfire");
		if ( ent != -1 )
		{
			DispatchSpawn(ent);
			DispatchKeyValueFloat(ent, "targetarc", 360.0);
			DispatchKeyValueFloat(ent, "targetrange", g_fCvarGuardRange);
			
			static char sWeaponType[2];
			if ( g_iCvarGuardWeaponType == 0 )
				FormatEx(sWeaponType, sizeof(sWeaponType), "%i", GetRandomInt(1,3));
			else
				FormatEx(sWeaponType, sizeof(sWeaponType), "%i", g_iCvarGuardWeaponType);
			
			DispatchKeyValue(ent, "weapontype", sWeaponType);
			DispatchKeyValue(ent, "targetteam", "3");
			DispatchKeyValueFloat(ent, "damagemod", g_fCvarGuardDamage);
			
			if( i % 3 == 0 ) SetVector(pos2, 0.0, 0.0, 55.0);
			else if( i % 3 == 1 ) SetVector(pos2, front, side,up);
			else if( i % 3 == 2 ) SetVector(pos2, front, 0.0 - side,up);

			DispatchKeyValue(ent, "parentname", tName);
			SetVariantString(tName);
			AcceptEntityInput(ent, "SetParent", ent, ent, 0);

			TeleportEntity(ent, pos2,NULL_VECTOR, NULL_VECTOR);
			AcceptEntityInput(ent, "Enable");
		}
		WitchGuardWeaponEnt[WitchGuardCount][i] = ent;
	}
	CalcOffset(pos, ang, 0.0,50.0, 0.0, pos2);
	
	DataPack pack;
	CreateDataTimer(g_fButtonTime, Timer_CreateButton, pack);
	pack.WriteCell(WitchGuardCount);
	pack.WriteCell(client);
	pack.WriteFloat(pos2[0]);
	pack.WriteFloat(pos2[1]);
	pack.WriteFloat(pos2[2]);
	
	WitchGuardEnt[WitchGuardCount] = witch;
	WitchGuardMolotov[WitchGuardCount] = molotov;
	WitchGuardSprite[WitchGuardCount] = env_sprite;
	WitchGuardScanTime[WitchGuardCount] = 0.0;
	WitchGuardCount++;

	#if DEBUG
	PrintToChatAll("Created witch guard: %i", witch);
	#endif
	
	return witch;
}

public Action Timer_CreateButton(Handle timer, DataPack pack)
{
	pack.Reset();

	int iWitchGuardCount = pack.ReadCell();
	int client = pack.ReadCell();
	float pos2[3];
	pos2[0] = pack.ReadFloat();
	pos2[1] = pack.ReadFloat();
	pos2[2] = pack.ReadFloat();
	
	int b;
	if( client && IsClientInGame(client) )
	{
		b = CreateButton(pos2, client);
	}
	g_bClientHasButton[client] = (b != -1);
	WitchGuardButton[iWitchGuardCount] = b;
	return Plugin_Continue;
}

public Action SetTransmitSprite(int entity, int client)
{
	if ( g_iSpriteOwner[entity] == client )
	{
		return Plugin_Continue;
	}
	return Plugin_Handled;
}

int CreateButton(float pos[3], int client)
{
	static char sTemp[16];
	int button;
	bool type=false;
	if( type )button = CreateEntityByName("func_button");
	else button = CreateEntityByName("func_button_timed");
	
	if ( button == -1 )
	{
		return -1;
	}
	
	DispatchKeyValue(button, "rendermode", "3");
	
	if( type )
	{
		DispatchKeyValue(button, "spawnflags", "1025");
		DispatchKeyValue(button, "wait", "1");
	}
	else
	{
		DispatchKeyValue(button, "spawnflags", "0");
		DispatchKeyValue(button, "auto_disable", "1");
		FormatEx(sTemp, sizeof(sTemp), "%f", 1.5);
		DispatchKeyValue(button, "use_time", sTemp);
	}
	DispatchSpawn(button);
	AcceptEntityInput(button, "Enable");
	ActivateEntity(button);

	TeleportEntity(button, pos, NULL_VECTOR, NULL_VECTOR);

	SetEntProp(button, Prop_Send, "m_nSolidType", 0, 1);
	SetEntProp(button, Prop_Send, "m_usSolidFlags", 4, 2);

	float vMins[3] = {-5.0, -5.0, -5.0}, vMaxs[3] = {10.0, 10.0, 10.0};
	SetEntPropVector(button, Prop_Send, "m_vecMins", vMins);
	SetEntPropVector(button, Prop_Send, "m_vecMaxs", vMaxs);

	SetEntPropEnt(button, Prop_Send, "m_hOwnerEntity", client);

	if( L4D2Version )
	{
		SetEntProp(button, Prop_Data, "m_CollisionGroup", 1);
		SetEntProp(button, Prop_Send, "m_CollisionGroup", 1);
	}
	if( type )
	{
		HookSingleEntityOutput(button, "OnPressed", OnPressed);
	}
	else
	{
		SetVariantString("OnTimeUp !self:Enable::1:-1");
		AcceptEntityInput(button, "AddOutput");
		HookSingleEntityOutput(button, "OnTimeUp", OnPressed);
	}
	return button;
}

public void OnPressed(const char[] output, int caller, int activator, float delay)
{
	if( caller && activator > 0 && activator <= MaxClients && IsClientInGame(activator) )
	{
		if( IsValidEntityEx(WitchEnt[activator] ) ) return;

		int owner = GetEntPropEnt(caller, Prop_Send, "m_hOwnerEntity");

		if ( !g_iCvarGuardSteal )
		{
			if ( activator != owner )
			{
				if ( owner > 0 && IsClientInGame(owner) ) // perhaps, better to reset to 0 ?
				{
					CPrintToChat(activator, "%t", "Steal_Witch", owner);
				}
				return;
			}
		}
		
		AcceptEntityInput(caller, "kill");
		int find = -1;
		for( int i = 0; i < WitchGuardCount; i++ )
		{
			if( WitchGuardButton[i] == caller )
			{
				find = i;
				break;
			}
		}
		if( find == -1 ) return;
		
		g_bClientHasButton[activator] = false;
		
		static char sModel[PLATFORM_MAX_PATH];
		sModel[0] = '\0';
		
		float pos_witch[3];
		int r = 255, g = 255, b = 255, a;
		
		if ( IsValidEntityEx(WitchGuardEnt[find]) )
		{
			GetEntPropString(WitchGuardEnt[find], Prop_Data, "m_ModelName", sModel, sizeof(sModel));
			GetEntityRenderColor(WitchGuardEnt[find], r, g, b, a);
			GetEntPropVector(WitchGuardMolotov[find], Prop_Data, "m_vecOrigin", pos_witch); // witch is attached to molotov!
		}
		
		OnWitchGuard_RemoveGround_Forward(activator, WitchGuardEnt[find], pos_witch);
		
		KillGuard(find);
		
		WitchGuardCount--;
		CreateDecoration(activator, sModel, r, g, b);
		
		PrintHintText(activator, "%t", "Put_back"); // "you put witch on back" );
	}
}

void KillGuardByEntity(int witch)
{
	float pos_witch[3];
	GetEntPropVector(witch, Prop_Data, "m_vecOrigin", pos_witch);
	OnWitchGuard_RemoveGround_Forward(0, witch, pos_witch);
	
	AcceptEntityInput(witch, "kill");
	
	int find = -1;
	for( int i = 0; i < WitchGuardCount; i++ )
	{
		if( WitchGuardEnt[i] == witch )
		{
			find = i;
			break;
		}
	}
	
	if( IsValidEntityEx(WitchGuardButton[find]) )
	{
		AcceptEntityInput(WitchGuardButton[find], "kill");
	}
	
	KillGuard(find);
	WitchGuardCount--;
}

void KillGuard(int find)
{
	for( int i = 0; i < WEAPON_MAX_PER_WITCH; i++ )
	{
		if ( IsValidEntityEx(WitchGuardWeaponEnt[find][i]) )
		{
			AcceptEntityInput(WitchGuardWeaponEnt[find][i], "kill");
		}
		WitchGuardWeaponEnt[find][i]=0;
	}

	if ( IsValidEntityEx(WitchGuardEnt[find]) )
	{
		AcceptEntityInput(WitchGuardEnt[find], "kill");
	}
	if ( IsValidEntityEx(WitchGuardMolotov[find]) )
	{
		AcceptEntityInput(WitchGuardMolotov[find], "kill");
	}
	if ( IsValidEntityEx(WitchGuardSprite[find]) )
	{
		SDKUnhook(WitchGuardSprite[find], SDKHook_SetTransmit, SetTransmitSprite);
		AcceptEntityInput(WitchGuardSprite[find], "kill");
	}
	
	for( int i = find; i < WitchGuardCount; i++ )
	{
		WitchGuardEnt[i] = WitchGuardEnt[i+1];
		WitchGuardButton[i] = WitchGuardButton[i+1];
		WitchGuardMolotov[i] = WitchGuardMolotov[i+1];
		WitchGuardSprite[i] = WitchGuardSprite[i+1];
		WitchGuardScanTime[i] = WitchGuardScanTime[i+1];
		
		for( int j = 0; j < WEAPON_MAX_PER_WITCH; j++ )
		{
			WitchGuardWeaponEnt[i][j]=WitchGuardWeaponEnt[i+1][j];
		}
	}
}

void CalcOffset(float pos[3], float ang[3], float front, float up, float right, float ret[3])
{
	float t[3];
	GetAngleVectors(ang, t, NULL_VECTOR, NULL_VECTOR);
	NormalizeVector(t, t);
	ScaleVector(t, front);
	AddVectors(pos, t, ret);

	GetAngleVectors(ang, NULL_VECTOR,t, NULL_VECTOR);
	NormalizeVector(t, t);
	ScaleVector(t, right);
	AddVectors(ret, t, ret);

	GetAngleVectors(ang, NULL_VECTOR,NULL_VECTOR, t);
	NormalizeVector(t, t);
	ScaleVector(t, up);
	AddVectors(ret, t, ret);
}

public void PreThinkClient(int client)
{
	if( !WitchEnt[client] ) return;
	
	int button = GetClientButtons(client);
	
	if( (button & IN_USE) && !(button & IN_DUCK) )
	{
		int targetRevive = GetEntPropEnt(client, Prop_Send, "m_reviveTarget");

		if ( targetRevive != -1 )
		{
			PressTime[client] = GetEngineTime();
			return;
		}

		if ( L4D2Version )
		{
			int targetUseAction = GetEntPropEnt(client, Prop_Send, "m_useActionTarget");

			if ( targetUseAction != -1)
			{
				PressTime[client] = GetEngineTime();
				return;
			}
		}

		if( GetEngineTime() - PressTime[client] > 1.5 )
		{
			if( !(GetEntityFlags(client) & FL_ONGROUND) )
				return;
			
			static char sModel[PLATFORM_MAX_PATH];
			
			DeleteDecoration(client, sModel);
			delete g_hTimerAnim[client];
			float pos[3];
			int witch = CreateWitchGuard(client, sModel, pos);
			if( witch != -1 )
			{
				OnWitchGuard_PutGround_Forward(client, witch, pos);
			}
			PrintHintText(client, "%t", "Put_down"); // "you put witch down" );
		}
	}
	else
	{
		PressTime[client] = GetEngineTime();
	}
}

public Action TimerAnimWitch(Handle timer, int UserId)
{
	int client = GetClientOfUserId(UserId);
	
	if( IsValidEntityEx(WitchEnt[client]) )
	{
		if( client && IsClientInGame(client) && IsPlayerAlive(client) && GetClientTeam(client) == 2 )
		{
			if ( IsSpineWitchEntity(WitchEnt[client]) )
			{
				int anim = Anim[ GetRandomInt(0,AnimCount-1) ];

				float ang[3];
				SetVector(ang, 0.0, 0.0, 90.0);
				float pos[3];
				pos[0] = OffSets[anim][0];
				pos[1] = OffSets[anim][1];
				
				TeleportEntity(WitchEnt[client], pos, ang, NULL_VECTOR);

				SetEntProp(WitchEnt[client], Prop_Send, "m_nSequence", anim);
				SetEntPropFloat(WitchEnt[client], Prop_Send, "m_flPlaybackRate", 1.0);
				return Plugin_Continue;
			}
			else {
				g_hTimerAnim[client] = INVALID_HANDLE;
				return Plugin_Stop;
			}
		}
		else
		{
			DeleteDecoration(client);
		}
	}
	WitchEnt[client] = 0;
	g_hTimerAnim[client] = INVALID_HANDLE;
	return Plugin_Stop;
}

public Action Hook_SetTransmit(int entity, int client)
{
	if( entity == WitchEnt[client] )
	{
		if ( !WitchViewOff[client] && IsSurvivorThirdPerson(client) )
			return Plugin_Continue;
		else
			return Plugin_Handled;
	}
	return Plugin_Continue;
}

void SetVector(float target[3], float x, float y, float z)
{
	target[0]=x;
	target[1]=y;
	target[2]=z;
}

bool IsValidClient(int iClient)
{
	return ( 0 < iClient <= MaxClients && IsClientInGame(iClient) );
}

stock void CPrintToChat(int client, const char[] format, any ...)
{
	char buffer[192];
	SetGlobalTransTarget(client);
	VFormat(buffer, sizeof(buffer), format, 3);
	ReplaceColor(buffer, sizeof(buffer));
	PrintToChat(client, "\x01%s", buffer);
}

stock void CPrintToChatAll(const char[] format, any ...)
{
	char buffer[192];
	for( int i = 1; i <= MaxClients; i++ )
	{
		if( IsClientInGame(i) && !IsFakeClient(i) )
		{
			SetGlobalTransTarget(i);
			VFormat(buffer, sizeof(buffer), format, 2);
			ReplaceColor(buffer, sizeof(buffer));
			PrintToChat(i, "\x01%s", buffer);
		}
	}
}

stock void ReplaceColor(char[] message, int maxLen)
{
	ReplaceString(message, maxLen, "{white}", "\x01", false);
	ReplaceString(message, maxLen, "{cyan}", "\x03", false);
	ReplaceString(message, maxLen, "{orange}", "\x04", false);
	ReplaceString(message, maxLen, "{green}", "\x05", false);
}

bool IsValidEntityEx(int ent)
{
	if( ent && IsValidEntity(ent) )
		return true;

	return false;
}

stock bool IsSpineWitchEntity(int iEntity)
{
	if( IsValidEntityEx(iEntity) )
	{
		static char sClassname[64];
		GetEntityClassname(iEntity, sClassname, sizeof(sClassname));
		return strcmp(sClassname, "prop_dynamic") == 0;
	}
	return false;
}

stock bool IsWitchEntity(int iEntity)
{
	if( IsValidEntityEx(iEntity) )
	{
		static char sClassname[64];
		GetEntityClassname(iEntity, sClassname, sizeof(sClassname));
		return strcmp(sClassname, "witch") == 0;
	}
	return false;
}

stock int GetRandomPlayer(int attacker)
{
	if ( g_iCvarGuardPrioritizeHumanPlayers )
	{
		for( int client = 1; client <= MaxClients; client++ )
		{
			if ( IsValidClient(client) )
			{
				if ( GetClientTeam(client) != 2 )
					continue;

				if ( IsFakeClient(client) )
					continue;

				if ( !IsPlayerAlive(client) )
					continue;

				if ( IsValidEntityEx(WitchEnt[client]) )
					continue;

				if ( g_bClientHasButton[client] )
					continue;

				return client;
			}
		}

		for( int client = 1; client <= MaxClients; client++ )
		{
			if ( IsValidClient(client) )
			{
				if ( GetClientTeam(client) != 2 )
					continue;

				if ( !IsFakeClient(client) )
					continue;

				if ( !IsPlayerAlive(client) )
					continue;

				if ( IsValidEntityEx(WitchEnt[client]) )
					continue;

				if ( g_bClientHasButton[client] )
					continue;

				return client;
			}
		}
	}
	else
	{
		for( int client = 1; client <= MaxClients; client++ )
		{
			if ( IsValidClient(client) )
			{
				if ( GetClientTeam(client) != 2 )
					continue;

				if ( !IsPlayerAlive(client) )
					continue;

				if ( IsValidEntityEx(WitchEnt[client]) )
					continue;

				if ( g_bClientHasButton[client] )
					continue;

				return client;
			}
		}
	}
	return attacker;
}

stock bool IsSurvivorThirdPerson(int iClient) // Thanks to Lux and Mr.GameOver
{
	return bThirdPerson[iClient] || g_iCvarDetectThirdPerson && (L4D2Version ? IsSurvivorThirdPersonL4D2(iClient) : IsSurvivorThirdPersonL4D1(iClient));
}

stock bool IsSurvivorThirdPersonL4D1(int iClient)
{
	if( GetEntPropEnt(iClient, Prop_Send, "m_hViewEntity") > 0 )
		return true;
	if( GetEntPropEnt(iClient, Prop_Send, "m_pounceAttacker") > 0 )
		return true;
	if( GetEntProp(iClient, Prop_Send, "m_isHangingFromLedge") > 0 )
		return true;
	if( GetEntPropEnt(iClient, Prop_Send, "m_reviveTarget") > 0 )
		return true;
	if( GetEntPropEnt(iClient, Prop_Send, "m_healTarget") > 0 )
		return true;
	if(GetEntPropFloat(iClient, Prop_Send, "m_staggerTimer", 1) > GetGameTime())
		return true;
	
	static char sModel[31];
	GetEntPropString(iClient, Prop_Data, "m_ModelName", sModel, sizeof(sModel));
	
	switch( sModel[29] )
	{
		case 'v'://bill
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 535, 537, 539, 540, 541:
				return true;
			}
		}
		case 'n'://zoey
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 517, 519, 521, 522, 523:
				return true;
			}
		}
		case 'e'://francis
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 536, 538, 540, 541, 542:
				return true;
			}
		}
		case 'a'://louis
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 535, 537, 539, 540, 541:
				return true;
			}
		}
	}
	return false;
}

stock bool IsSurvivorThirdPersonL4D2(int iClient)
{
	if(GetEntPropEnt(iClient, Prop_Send, "m_hViewEntity") > 0)
		return true;
	if(GetEntPropFloat(iClient, Prop_Send, "m_TimeForceExternalView") > GetGameTime())
		return true;
	if(GetEntPropEnt(iClient, Prop_Send, "m_pummelAttacker") > 0)
		return true;
	if(GetEntPropEnt(iClient, Prop_Send, "m_carryAttacker") > 0)
		return true;
	if(GetEntPropEnt(iClient, Prop_Send, "m_pounceAttacker") > 0)
		return true;
	if(GetEntPropEnt(iClient, Prop_Send, "m_jockeyAttacker") > 0)
		return true;
	if(GetEntProp(iClient, Prop_Send, "m_isHangingFromLedge") > 0)
		return true;
	if(GetEntPropEnt(iClient, Prop_Send, "m_reviveTarget") > 0)
		return true;
	if(GetEntPropFloat(iClient, Prop_Send, "m_staggerTimer", 1) > -1.0)
		return true;
	
	switch(GetEntProp(iClient, Prop_Send, "m_iCurrentUseAction"))
	{
		case 1:
		{
			static int iTarget;
			iTarget = GetEntPropEnt(iClient, Prop_Send, "m_useActionTarget");
			
			if(iTarget == GetEntPropEnt(iClient, Prop_Send, "m_useActionOwner"))
				return true;
			else if(iTarget != iClient)
				return true;
		}
		case 4, 5, 6, 7, 8, 9, 10:
		return true;
	}
	
	static char sModel[31];
	GetEntPropString(iClient, Prop_Data, "m_ModelName", sModel, sizeof(sModel));
	
	switch(sModel[29])
	{
		case 'b'://nick
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 626, 625, 624, 623, 622, 621, 661, 662, 664, 665, 666, 667, 668, 670, 671, 672, 673, 674, 620, 680, 616:
				return true;
			}
		}
		case 'd', 'w'://rochelle, adawong
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 674, 678, 679, 630, 631, 632, 633, 634, 668, 677, 681, 680, 676, 675, 673, 672, 671, 670, 687, 629, 625, 616:
				return true;
			}
		}
		case 'c'://coach
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 656, 622, 623, 624, 625, 626, 663, 662, 661, 660, 659, 658, 657, 654, 653, 652, 651, 621, 620, 669, 615:
				return true;
			}
		}
		case 'h'://ellis
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 625, 675, 626, 627, 628, 629, 630, 631, 678, 677, 676, 575, 674, 673, 672, 671, 670, 669, 668, 667, 666, 665, 684, 621:
				return true;
			}
		}
		case 'v'://bill
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 528, 759, 763, 764, 529, 530, 531, 532, 533, 534, 753, 676, 675, 761, 758, 757, 756, 755, 754, 527, 772, 762, 522:
				return true;
			}
		}
		case 'n'://zoey
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 537, 819, 823, 824, 538, 539, 540, 541, 542, 543, 813, 828, 825, 822, 821, 820, 818, 817, 816, 815, 814, 536, 809, 572:
				return true;
			}
		}
		case 'e'://francis
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 532, 533, 534, 535, 536, 537, 769, 768, 767, 766, 765, 764, 763, 762, 761, 760, 759, 758, 757, 756, 531, 530, 775, 525:
				return true;
			}
		}
		case 'a'://louis
		{
			switch(GetEntProp(iClient, Prop_Send, "m_nSequence"))
			{
				case 529, 530, 531, 532, 533, 534, 766, 765, 764, 763, 762, 761, 760, 759, 758, 757, 756, 755, 754, 753, 527, 772, 528, 522:
				return true;
			}
		}
	}
	return false;
}

void OnWitchGuard_PutGround_Forward(int client, int witch, float pos[3])
{
	Action result;
	Call_StartForward(g_hOnPutGround);
	Call_PushCell(client);
	Call_PushCell(witch);
	Call_PushArray(pos, sizeof(pos));
	Call_Finish(result);
}

void OnWitchGuard_RemoveGround_Forward(int client, int witch, float pos[3])
{
	Action result;
	Call_StartForward(g_hOnRemoveGround);
	Call_PushCell(client);
	Call_PushCell(witch);
	Call_PushArray(pos, sizeof(pos));
	Call_Finish(result);
}
