#if defined _witchguard_included_
  #endinput
#endif
#define _witchguard_included_

/**
 * Safely removes witch prop.
 *
 * @param iWitch		Witch prop.
  *
 * @error				Entity is not valid.
 * @noreturn
 */
native void WG_WitchRemove(int iWitch);

/**
 * Called whenever player put the witch on the ground.
 *
 * @param iClient		Client index who put the witch
 * @param iWitch		Witch prop.
 * @param fVec[3]		Witch coordinates
  *
 * @noreturn
 */
forward void OnWitchGuard_PutGround(int iClient, int iWitch, float fVec[3]);

/**
 * Called whenever player took the witch guard from the ground.
 *
 * @param iClient		Client index
 * @param iWitch		Witch prop.
 * @param fVec[3]		Witch coordinates
  *
 * @noreturn
 */
forward void OnWitchGuard_RemoveGround(int iClient, int iWitch, float fVec[3]);

public SharedPlugin __pl_witchguard =
{
	name = "witch_guard_l4d",
	file = "witch_guard_l4d.smx",
	#if defined REQUIRE_PLUGIN
	required = 1
	#else
	required = 0
	#endif
};

#if !defined REQUIRE_PLUGIN
public void __pl_witchguard_SetNTVOptional()
{
	MarkNativeAsOptional("WG_WitchRemove");
}
#endif